/* ***************************************************************************************
* FILE:          SwipePositionObserver.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SwipePositionObserver is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef Flex_SwipePositionObserver_H
#define Flex_SwipePositionObserver_H

#include <FeatStd/Platform/Types.h>


#include "PositioningHandler.h"

class SwipePositionObserver
{
   public:
      SwipePositionObserver();

      void Init(PositioningHandler* positioningHandler);

      void OnGestureBegin();
      void OnScrollEnd();
      void OnSwipeEnd();

      FeatStd::Float GetPositionDelta() const;

   private:
      PositioningHandler* _positioningHandler;
      FeatStd::Float _gestureBeginPosition;
      FeatStd::Float _gestureEndPosition;
};


#endif
