/* ***************************************************************************************
* FILE:          SwipePositionObserver.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SwipePositionObserver is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "SwipePositionObserver.h"

#include <Candera/System/Mathematics/Math.h>
#include <FeatStd/Platform/PerfCounter.h>
#include <TouchGestures/GestureBasetypes.h>
#include <hmibase/util/Ticker.h>
#include <Widgets/2D/Common/FlexScrollable.h>

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/SwipePositionObserver.cpp.trc.h"
#endif


using namespace FeatStd;
using namespace Candera;

SwipePositionObserver::SwipePositionObserver() :
   _positioningHandler(0),
   _gestureBeginPosition(0),
   _gestureEndPosition(0)
{
}


void SwipePositionObserver::Init(PositioningHandler* positioningHandler)
{
   _positioningHandler = positioningHandler;
}


void SwipePositionObserver::OnGestureBegin()
{
   _gestureBeginPosition = 0.0F;
   _gestureEndPosition = 0.0F;

   if (0 != _positioningHandler)
   {
      _gestureBeginPosition = _positioningHandler->GetCurrentPosition();
   }
}


void SwipePositionObserver::OnScrollEnd()
{
   if (0 != _positioningHandler)
   {
      _gestureEndPosition = _positioningHandler->GetCurrentPosition();
   }
}


void SwipePositionObserver::OnSwipeEnd()
{
   if (0 != _positioningHandler)
   {
      _gestureEndPosition = _positioningHandler->GetCurrentPosition();
   }
}


FeatStd::Float SwipePositionObserver::GetPositionDelta() const
{
   return _gestureEndPosition - _gestureBeginPosition;
}
