/* ***************************************************************************************
* FILE:          SwipeCalculator.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SwipeCalculator is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef SwipeCalculator_H
#define SwipeCalculator_H

#include <FeatStd/Platform/Types.h>

#include "SwipingStateChecker.h"
#include "Widgets/2D/List/Content/ItemSizesContainer.h"
#include "PositioningHandler.h"
#include <TouchGestures/GestureBasetypes.h>
#include <Widgets/2D/List/Swiping/SwipingAdjuster.h>
#include <Courier/Foundation/FoundationMsgs.h>
#include <Widgets/2D/List/Swiping/SwipingListener.h>
#include <Widgets/2D/List/Content/TimeDispatcher.h>
#include <Widgets/2D/List/Animations/ItemSpeedAnimationManager.h>

class FlexScrollable;

class SwipeCalculator : public SwipingStateChecker
{
   public:
      SwipeCalculator(ItemSpeedAnimationManager& itemSpeedAnimationManager);
      virtual ~SwipeCalculator();

      void Init(FlexScrollable* scrollable, TimeDispatcher* timeDispatcher, SwipingAdjuster* swipingAdjuster);

      void SetSwipingAcceleration(const FeatStd::Float& swipingAcceleration);
      void SetMaxSwipingDistance(FeatStd::Float val);
      void RegisterListener(SwipingListener* listener);

      /**
      * @return true if the invalidation is needed; false otherwise
      */
      bool Update();

      void Reset();

      bool OnDragGesture(const hmibase::input::gesture::GestureEvent& gestureData);
      bool OnSwipeGesture(const hmibase::input::gesture::GestureEvent& gestureData);

      virtual bool IsIdle() const override;
      virtual bool IsTouched() const override;
      virtual bool IsFocused() const override;
      virtual bool WasScrolling() const override;
      virtual bool IsScrolling() const override;

   private:
      // private copy constructor and assignment operator, not intended to be called
      SwipeCalculator(const SwipeCalculator& other);
      SwipeCalculator& operator =(const SwipeCalculator& other);

      Courier::Float GetPosition(const Candera::Vector2& touchPoint) const;
      bool ValidDirection(const hmibase::input::gesture::GestureEvent& gestureData) const;
      bool ValidPoint(const hmibase::input::gesture::GestureEvent& gestureData) const;
      bool ValidVelocity(const hmibase::input::gesture::GestureEvent& gestureData) const;
      FeatStd::Float GetVelocity(const hmibase::input::gesture::Vector2D& velocity2D) const;
      Candera::Float GetDistance(Courier::Float pos) const;
      Candera::UInt32 GetTouchInterval(Candera::UInt32 now) const;

      void OnGestureBegin(const Candera::Vector2& position);

      void OnScrollStart(const Candera::Vector2& touchPosition, int timestamp);
      void OnScroll(const Candera::Vector2& touchPosition);
      void OnScrollEnd(const Candera::Vector2& touchPosition);

      void OnSwipeStart(const Candera::Vector2& touchPosition);
      void OnSwipe(int timestamp);
      void OnSwipeEnd();

      void AdjustSwipingParameters();
      void AdjustInitialSwipedDistance();

      FeatStd::UInt32 GetTimeNow() const;

      void SetState(SwipingState::Enum state);

      FlexScrollable* _scrollable;
      TimeDispatcher* _timeDispatcher;
      SwipingAdjuster* _swipingAdjuster;
      SwipingListener* _listener;
      FeatStd::Float _startPosition;
      Candera::Vector2 _lastScrollPosition;
      FeatStd::Float _detectDirectionPosition;
      FeatStd::UInt32 _startTime;
      FeatStd::Float _velocity;
      FeatStd::Float _lastScrollTime;
      bool _isVelocityAdjustable;
      FeatStd::Float _swipingAcceleration;
      FeatStd::Float _maxSwipingDistance;
      Candera::Float _remainingSwipeDistance;
      SwipingState::Enum _state;
      SwipingState::Enum _previousState;
      bool _startSwiping;
      ItemSpeedAnimationManager& _itemSpeedAnimationManager;
};


#endif
