/* ***************************************************************************************
* FILE:          PageLockoutSwipingBehavior.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PageLockoutSwipingBehavior is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "PageLockoutSwipingBehavior.h"

#include <FeatStd/Platform/Math.h>

using namespace FeatStd;
using namespace Candera;
using namespace Courier;

PageLockoutSwipingBehavior::PageLockoutSwipingBehavior(Swiper& swiper, ListWidget2D& listWidget, const OrientationOperator& orientationOperator, const PageSwipingBehaviorInfo& info) :
   _swiper(swiper),
   _listWidget(listWidget),
   _orientationOperator(orientationOperator),
   _info(info)
{
}


void PageLockoutSwipingBehavior::StartScrollImpl(const Candera::Vector2& pos)
{
   _scrollStartPosition = pos;
}


bool PageLockoutSwipingBehavior::ScrollImpl(FeatStd::Float /*movementDistance*/, bool /*forward*/)
{
   return true;
}


void PageLockoutSwipingBehavior::EndScrollImpl(const Candera::Vector2& pos)
{
   const Float& initialPos(_orientationOperator.GetVectorComponent(_scrollStartPosition));
   const Float& finalPos(_orientationOperator.GetVectorComponent(pos));
   if (finalPos != initialPos)
   {
      Float distance = MathPlatform::Absolute(initialPos - finalPos);
      if (_info.IsThresholdMet(_orientationOperator, distance))
      {
         const bool forward(finalPos < initialPos);

         const Int32 currentStartIndex(_listWidget.GetStartIndex());

         Int32 expectedStartIndex(currentStartIndex);
         _listWidget.GetPagesInfo().RetrieveStartIndexOfPage(forward ? 1 : -1, expectedStartIndex);

         _listWidget.RequestImmediatePositioning(true);
         _listWidget.SetStartIndex(expectedStartIndex);
         _listWidget.Invalidate();
      }
   }
   RequestIdle();
}


bool PageLockoutSwipingBehavior::SwipeImpl(FeatStd::Float /*movementDistance*/, bool /*forward*/)
{
   return true;
}
