/* ***************************************************************************************
* FILE:          OverscrollMover.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OverscrollMover is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef OverscrollMover_H
#define OverscrollMover_H

#include <FeatStd/Platform/Types.h>


class OverscrollMover
{
   public:
      virtual ~OverscrollMover() { }

      virtual void Move(FeatStd::Float movingDistance, bool forward) = 0;

      virtual FeatStd::Float GetMovedDistance() const = 0;

      virtual void SetInitialSwipeOverscrollDistance(FeatStd::Float distance) = 0;
      virtual FeatStd::Float GetExtraDistanceForSwipe() const = 0;

   private:
};


#endif
