/* ***************************************************************************************
* FILE:          OverscrollFunctionRetriever.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OverscrollFunctionRetriever is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "widget2D_std_if.h"

#include "OverscrollFunctionRetriever.h"
#include <Widgets/2D/ControlTemplate/ControlTemplate.h>
#include <Widgets/2D/ListOverscroll/ListOverscrollWidget2D.h>


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/OverscrollFunctionRetriever.cpp.trc.h"
#endif

using namespace Candera;

OverscrollFunctionRetriever::OverscrollFunctionRetriever()
{
}


OverscrollFunctionRetriever::~OverscrollFunctionRetriever()
{
}


OverscrollFunction* OverscrollFunctionRetriever::Retrieve(Candera::Node2D* searchNode)
{
   OverscrollFunction* function(0);

   if (0 != searchNode)
   {
      ControlTemplateData* data(ControlTemplate::TryGetControlTemplateData(*searchNode));

      if (0 != data)
      {
         WidgetBaseEnumerator enumerator(data->EnumerateAssociatedWidgets());

         while ((0 == function) && (enumerator.MoveNext()))
         {
            WidgetBase* widgetBase(enumerator.Current());
            function = Dynamic_Cast<ListOverscrollWidget2D*>(widgetBase);
         }
      }
   }
   return function;
}
