/* ***************************************************************************************
* FILE:          ListPageSwipingBehaviorInfo.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListPageSwipingBehaviorInfo is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ListPageSwipingBehaviorInfo_H
#define ListPageSwipingBehaviorInfo_H

#include <Widgets/2D/List/Swiping/PageSwipingBehaviorInfo.h>

class ListWidget2D;

class ListPageSwipingBehaviorInfo : public PageSwipingBehaviorInfo
{
   public:
      ListPageSwipingBehaviorInfo();
      virtual ~ListPageSwipingBehaviorInfo();

      void SetScrollOffsetPercentage(FeatStd::Float val);
      void SetVisibleArea(const Candera::Vector2& val);

      virtual const Candera::Vector2 GetVisibleArea() const;
      virtual const FeatStd::Float GetScrollOffsetPercentage() const;

   private:
      FeatStd::Float _offsetPercentage;
      Candera::Vector2 _visibleArea;
};


#endif
