/* ***************************************************************************************
* FILE:          ListPageSwipingBehaviorInfo.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListPageSwipingBehaviorInfo is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include <Widgets/2D/List/ListWidget2D.h>
#include <Widgets/2D/List/Content/ListPagesInfo.h>

#include "ListPageSwipingBehaviorInfo.h"

using namespace FeatStd;


ListPageSwipingBehaviorInfo::ListPageSwipingBehaviorInfo() :
   _offsetPercentage(0),
   _visibleArea()
{
}


ListPageSwipingBehaviorInfo::~ListPageSwipingBehaviorInfo()
{
}


void ListPageSwipingBehaviorInfo::SetScrollOffsetPercentage(FeatStd::Float val)
{
   _offsetPercentage = val;
}


void ListPageSwipingBehaviorInfo::SetVisibleArea(const Candera::Vector2& val)
{
   _visibleArea = val;
}


const Candera::Vector2 ListPageSwipingBehaviorInfo::GetVisibleArea() const
{
   return _visibleArea;
}


const FeatStd::Float ListPageSwipingBehaviorInfo::GetScrollOffsetPercentage() const
{
   return _offsetPercentage;
}
