/* ***************************************************************************************
* FILE:          ItemSwipingBehavior.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ItemSwipingBehavior is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ItemSwipingBehavior_H
#define ItemSwipingBehavior_H

#include <FeatStd/Platform/Types.h>
#include <Widgets/2D/List/Swiping/Swiper.h>
#include <Widgets/2D/List/Swiping/SwipingBehavior.h>
#include <Courier/Visualization/FrameworkWidget.h>
#include <Widgets/2D/List/Content/Adders/OrientationOperator.h>

class ItemSwipingBehavior : public SwipingBehavior
{
   public:
      FEATSTD_TYPEDEF_BASE(SwipingBehavior);

      ItemSwipingBehavior(Swiper& swiper);

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(ItemSwipingBehavior);

      Swiper& _swiper;

      virtual bool ScrollImpl(FeatStd::Float movementDistance, bool forward);
      virtual bool SwipeImpl(FeatStd::Float movementDistance, bool forward);
};


#endif
