/* ***************************************************************************************
* FILE:          ItemLockoutSwipingBehavior.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ItemLockoutSwipingBehavior is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ItemLockoutSwipingBehavior_H
#define ItemLockoutSwipingBehavior_H

#include <FeatStd/Platform/Types.h>
#include <Widgets/2D/List/ListWidget2D.h>
#include <Widgets/2D/List/Content/Adders/OrientationOperator.h>
#include <Widgets/2D/List/Swiping/SwipingBehavior.h>
#include <Widgets/2D/List/Swiping/PageSwipingBehaviorInfo.h>

class ItemLockoutSwipingBehavior : public SwipingBehavior
{
   public:
      ItemLockoutSwipingBehavior(ListWidget2D& listWidget, const OrientationOperator& orientationOperator, const PageSwipingBehaviorInfo& info);

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(ItemLockoutSwipingBehavior);

      ListWidget2D& _listWidget;
      const OrientationOperator& _orientationOperator;
      Candera::Vector2 _scrollStartPosition;
      const PageSwipingBehaviorInfo& _info;

      virtual void StartScrollImpl(const Candera::Vector2& pos);

      virtual bool ScrollImpl(FeatStd::Float movementDistance, bool forward);
      virtual void EndScrollImpl(const Candera::Vector2& pos);

      virtual bool SwipeImpl(FeatStd::Float movementDistance, bool forward);
};


#endif
