/* ***************************************************************************************
* FILE:          DefaultOverscroller.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultOverscroller is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef DefaultOverscroller_H
#define DefaultOverscroller_H

#include "OverscrollFunction.h"
#include <Widgets/2D/List/Content/Adders/OrientationOperator.h>
#include <Widgets/2D/List/Swiping/Overscroller.h>
#include <Widgets/2D/List/Content/TimeDispatcher.h>

class DefaultOverscroller : public Overscroller
{
   public:
      DefaultOverscroller(const OrientationOperator& orientationOperator, TimeDispatcher& timeDispatcher);
      virtual ~DefaultOverscroller();

      void SetContentNode(Candera::Node2D* contentNode)
      {
         _contentNode = contentNode;
      }

      void SetViewportSize(Candera::Vector2 viewportSize);

      void SetOverscrollFunction(OverscrollFunction* function)
      {
         _function = function;
      }

      void SetListener(OverscrollerListener* listener);

      virtual void Move(FeatStd::Float movingDistance, bool forward) override;
      virtual FeatStd::Float GetMovedDistance() const override;
      virtual void SetInitialSwipeOverscrollDistance(FeatStd::Float distance) override;
      virtual FeatStd::Float GetExtraDistanceForSwipe() const override;
      virtual bool Update(bool idleRequested) override;

      virtual void BeginGesture(const Candera::Vector2& position) override;
      virtual void StartScroll(const Candera::Vector2& pos) override;
      virtual void EndScroll(const Candera::Vector2& pos) override;
      virtual void StartSwipe(const Candera::Float estimatedDistance) override;
      virtual void EndSwipe() override;
   private:
      const OrientationOperator& _orientationOperator;
      TimeDispatcher& _timeDispatcher;
      Candera::Node2D* _contentNode;
      FeatStd::Float _viewportSize;
      FeatStd::Float _viewportRatio;
      FeatStd::Float _viewportRatioInverse;
      OverscrollFunction* _function;
      FeatStd::Float _swipeOverscrollDistance;
      OverscrollerListener* _listener;

      bool _swiping;
      bool _moving;
      FeatStd::Float _movedDistance;
      FeatStd::Float _overscrolledDistance;
      bool _forward;
      bool _forwardStartedMovement;
      bool _relax;
      bool _shouldEnd;
      FeatStd::UInt32 _relaxT0;

      FeatStd::Float Overscroll();
      FeatStd::Float Relax();
      void UpdateMargin();
      void UpdateMovementEnd();
      void NotifyListener();

      bool IsDragAllowed() const;
      bool IsSwipeAllowed() const;
};


#endif
