/* ***************************************************************************************
* FILE:          DefaultNormalizer.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultNormalizer is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "widget2D_std_if.h"

#include <Candera/System/Mathematics/Math.h>
#include "DefaultNormalizer.h"


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/DefaultNormalizer.cpp.trc.h"
#endif


using namespace FeatStd;
using namespace Candera;


DefaultNormalizer::DefaultNormalizer()
{
}


DefaultNormalizer::~DefaultNormalizer()
{
}


Float DefaultNormalizer::Normalize(Float x, const ItemSizesContainer::SizesVector& itemSizes) const
{
   Float absX(Math::Absolute(x));
   Float positions(0.0F);
   Float lastSize(0.0F);
   const Float sign((x != absX) ? -1.0f : 1.0f);

   bool all0(false);

   while (absX > 0 && !all0)
   {
      all0 = true;
      for (Int32 i(0); (absX > 0) && (i < (Int32) itemSizes.Size()); ++i)
      {
         lastSize = itemSizes[i];
         all0 &= (lastSize == 0);

         absX -= lastSize;
         positions += 1.0F;
      }
   }

   Float delta(0 - absX);

   if (lastSize != 0)
   {
      positions -= delta / lastSize;
   }

   return sign * positions;
}


Float DefaultNormalizer::Denormalize(Float x, const ItemSizesContainer::SizesVector& itemSizes) const
{
   Float absX(Math::Absolute(x));
   Float distance(0.0F);
   Float lastSize(0.0F);
   const Float sign((x != absX) ? -1.0f : 1.0f);

   bool all0(false);

   while (absX > 0 && !all0)
   {
      all0 = true;
      for (Int32 i(0); (absX > 0) && (i < (Int32) itemSizes.Size()); ++i)
      {
         lastSize = itemSizes[i];
         all0 &= (lastSize == 0);

         absX -= 1.0F;
         distance += lastSize;
      }
   }

   Float delta(0 - absX);

   distance -= delta * lastSize;

   return sign * distance;
}
