/* ***************************************************************************************
* FILE:          CoverflowNormalizer.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CoverflowNormalizer is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef CoverflowNormalizer_H
#define CoverflowNormalizer_H

#include <FeatStd/Platform/Types.h>
#include <Widgets/2D/List/Swiping/Normalizer.h>


class CoverflowNormalizer : public Normalizer
{
   public:
      CoverflowNormalizer();
      virtual ~CoverflowNormalizer();

      virtual FeatStd::Float Normalize(FeatStd::Float x, const ItemSizesContainer::SizesVector& itemSizes) const override;
      virtual FeatStd::Float Denormalize(FeatStd::Float x, const ItemSizesContainer::SizesVector& itemSizes) const override;

   private:
};


#endif
