/* ***************************************************************************************
* FILE:          EdgeItemSnapper.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  EdgeItemSnapper is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "EdgeItemSnapper.h"
#include <Candera/System/Container/Vector.h>

#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/Layouter.h>
#else
#include <Candera/Engine2D/Layout/Layouter.h>
#endif

#include "ItemSnapperHelper.h"

using namespace Candera;

EdgeItemSnapper::EdgeItemSnapper(TargetPositioner& targetPositioner) :
   Base(targetPositioner)
{
}


EdgeItemSnapper::~EdgeItemSnapper()
{
}


void EdgeItemSnapper::SnapImpl(const SnappingInfo& snappingInfo)
{
   const Normalizer* normalizer = GetNormalizer();
   if (0 != normalizer)
   {
      Float currentPosition(snappingInfo._currentPosition);

      Float deltaToEdge = GetDeltaToEdge(snappingInfo);
      Float normalizedDelta = normalizer->Normalize(deltaToEdge, snappingInfo._nodeSizes);
      Float targetPosition = currentPosition + normalizedDelta;

      GetTargetPositioner().SetTargetPosition(targetPosition, false);
   }
}


FeatStd::Float EdgeItemSnapper::GetDeltaToEdge(const SnappingInfo& snappingInfo) const
{
   Float topDelta = 0.0f;
   Float bottomDelta = 0.0f;
   Float delta = 0.0f;

   ItemsInfoType effectivePositions;

   // snapping delta is calculated based on the item positions and sizes including possible child margins
   ItemSnapperHelper().GetEffectiveNodePositions(snappingInfo, false, effectivePositions);

   if (effectivePositions.Size() > 0 && snappingInfo._nodeSizes.Size() > 0)
   {
      Float firstSize = snappingInfo._nodeSizes[0];
      Float firstItemTopDelta = effectivePositions[0];
      Float firstItemBottomDelta = firstItemTopDelta + firstSize;
      topDelta = (Math::Absolute(firstItemTopDelta) < firstItemBottomDelta) ? firstItemTopDelta : firstItemBottomDelta;

      Float lastSize = snappingInfo._nodeSizes[snappingInfo._nodeSizes.Size() - 1];
      Float lastPosition = effectivePositions[effectivePositions.Size() - 1];
      Float lastItemTopDelta = lastPosition - snappingInfo._viewportSize;
      Float lastItemBottomDelta = lastItemTopDelta + lastSize;
      bottomDelta = (Math::Absolute(lastItemTopDelta) < Math::Absolute(lastItemBottomDelta)) ? lastItemTopDelta : lastItemBottomDelta;
   }

   Float absTopDelta = Math::Absolute(topDelta);
   Float absBottomDelta = Math::Absolute(bottomDelta);

   if (Math::Absolute(absTopDelta - absBottomDelta) > GetThreshold())
   {
      delta = (absTopDelta < absBottomDelta) ? topDelta : bottomDelta;
   }
   else
   {
      FeatStd::Float touchPos = GetTouchPos();
      delta = (Math::Absolute(touchPos) < Math::Absolute((snappingInfo._viewportSize - touchPos))) ? topDelta : bottomDelta;
   }

   return delta;
}
