/* ***************************************************************************************
* FILE:          DefaultItemSnapper.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultItemSnapper is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "DefaultItemSnapper.h"

using namespace Candera;

DefaultItemSnapper::DefaultItemSnapper(TargetPositioner& targetPositioner) :
   Base(targetPositioner)
{
}


DefaultItemSnapper::~DefaultItemSnapper()
{
}


void DefaultItemSnapper::SnapImpl(const SnappingInfo& itemsInfo)
{
   Float currentPosition(itemsInfo._currentPosition);

   if (!itemsInfo._scrolling || GetPagewiseSnap())
   {
      if ((itemsInfo._forward))
      {
         currentPosition = Math::Ceil(itemsInfo._currentPosition);
      }
      else
      {
         currentPosition = Math::Floor(itemsInfo._currentPosition);
      }
   }

   GetTargetPositioner().SetTargetPosition(currentPosition, false);
}
