/* ***************************************************************************************
* FILE:          CenterItemSnapper.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CenterItemSnapper is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "widget2D_std_if.h"
#include "CenterItemSnapper.h"
#include <Candera/System/Container/Vector.h>

#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/Layouter.h>
#else
#include <Candera/Engine2D/Layout/Layouter.h>
#endif

#include "ItemSnapperHelper.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/CenterItemSnapper.cpp.trc.h"
#endif
using namespace Candera;

CenterItemSnapper::CenterItemSnapper(TargetPositioner& targetPositioner) :
   Base(targetPositioner)
{
}


CenterItemSnapper::~CenterItemSnapper()
{
}


void CenterItemSnapper::SnapImpl(const SnappingInfo& snappingInfo)
{
   const Normalizer* normalizer = GetNormalizer();
   if (0 != normalizer)
   {
      Float currentPosition(snappingInfo._currentPosition);
      Float deltaToCenter = ItemSnapperHelper().GetDeltaToCenter(snappingInfo);

      Float normalizedDelta = normalizer->Normalize(deltaToCenter, snappingInfo._nodeSizes);
      Float targetPosition = currentPosition - normalizedDelta;

      GetTargetPositioner().SetTargetPosition(targetPosition, false);
   }
}
