/* ***************************************************************************************
* FILE:          ListPrioWidgetComparator.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListPrioWidgetComparator is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include <Widgets/2D/List/ListWidget2D.h>
#include <Widgets/2D/ScrollBar/ScrollBarWidget2D.h>

#include "ListPrioWidgetComparator.h"

bool ListPrioWidgetComparator::operator()(Courier::FrameworkWidget* a, Courier::FrameworkWidget* b) const
{
   Candera::Widget2D* widget_a = dynamic_cast<Candera::Widget2D*>(a);
   Candera::Widget2D* widget_b = dynamic_cast<Candera::Widget2D*>(b);
   return ((0 != widget_a) && (0 != widget_b)) ?
          (widget_a->IsTypeOf(ListWidget2D::GetTypeId()) ||
           (widget_a->IsTypeOf(ScrollBarWidget2D::GetTypeId()) && !widget_b->IsTypeOf(ListWidget2D::GetTypeId()))) : false;
}
