/* ***************************************************************************************
* FILE:          FlexCanvasLayouter.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FlexCanvasLayouter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(FlexCanvasLayouter_H)
#define FlexCanvasLayouter_H

#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/Layouter.h>
#else
#include <Candera/Engine2D/Layout/Layouter.h>
#endif

#include <Courier/Version.h>

class FlexCanvasLayouter : public Candera::Layouter
{
   public:
      static void SetLayoutChildren(Candera::Node2D& node, const bool& value);

      static bool IsLayoutChildrenSet(const Candera::Node2D& node);

      static bool GetLayoutChildren(const Candera::Node2D& node);

      virtual ~FlexCanvasLayouter()
      {
      }

      /**
          *  Gets the instance of this class.
          *  @return A pointer to the instance of this class.
          */
      static FlexCanvasLayouter* GetInstance();

      /**
          *  This is a singleton so dispose does nothing.
          */
      virtual void Dispose();

   protected:
      Candera::Vector2 OnMeasure(Candera::Node2D& node, const Candera::Vector2& clientArea);

      void OnArrange(Candera::Node2D& node, const Candera::Rectangle& clientArea);

#if ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5))
      virtual Candera::Vector2 OnMeasure(const Candera::AbstractNodePointer& node, const Candera::Vector2& clientArea) override
      {
         return OnMeasure(*(node.ToNode2D()), clientArea);
      }

      virtual void OnArrange(const Candera::AbstractNodePointer& node, const Candera::Rectangle& clientArea) override
      {
         OnArrange(*(node.ToNode2D()), clientArea);
      }
#endif

      virtual Candera::Layouter* Clone() const
      {
         return GetInstance();
      }

      CdaDynamicProperties(FlexCanvasLayouter, Candera::Layouter);
      CdaDynamicProperty(LayoutChildren, bool);
      CdaDynamicPropertyDescription("Defines is the canvas layouter performs the layouting on the child nodes.")
      CdaDynamicPropertyDefaultValue(false)
      CdaDynamicPropertyCategory("Layouter")
      CdaDynamicPropertyEnd();
      CdaDynamicPropertiesEnd();

   private:
      CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704, Candera::OverlayLayouter::FlexCanvasLayouter, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
      FlexCanvasLayouter();
};


#endif
