/* ***************************************************************************************
* FILE:          CommonAncestorLayouter.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CommonAncestorLayouter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "CommonAncestorLayouter.h"

CommonAncestorLayouter::CommonAncestorLayouter(Candera::Layouter* originalLayouter) :
   FlexHookLayouter(originalLayouter)
{
}


CommonAncestorLayouter::~CommonAncestorLayouter()
{
}


Candera::Vector2 CommonAncestorLayouter::OnMeasure(Candera::Node2D& node, const Candera::Vector2& clientArea)
{
   FlexHookLayouter::ShouldNotifyListeners() = true;
   FEATSTD_UNUSED(FlexHookLayouter::OnMeasure(node, clientArea));
   FlexHookLayouter::ShouldNotifyListeners() = false;
   Candera::Vector2 measuredSize = FlexHookLayouter::OnMeasure(node, clientArea);
   FlexHookLayouter::ShouldNotifyListeners() = true;

   return measuredSize;
}
