/* ***************************************************************************************
* FILE:          DefaultOwnerInfoRetriever.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultOwnerInfoRetriever is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef DefaultOwnerInfoRetriever_H
#define DefaultOwnerInfoRetriever_H

#include <Widgets/2D/Common/OwnerInfoRetriever.h>

class DefaultOwnerInfoRetriever : public OwnerInfoRetriever
{
   public:
      DefaultOwnerInfoRetriever();
      virtual ~DefaultOwnerInfoRetriever();

      void SetOwner(BaseWidget2D* val)
      {
         _owner = val;
      }
      virtual BaseWidget2D* GetOwner() const override
      {
         return _owner;
      }

      void SetOwnerId(FeatStd::UInt32 val)
      {
         _ownerId = val;
      }
      virtual FeatStd::UInt32 GetOwnerId() const override
      {
         return _ownerId;
      }

   private:
      BaseWidget2D* _owner;
      FeatStd::UInt32 _ownerId;
};


#endif
