/* ***************************************************************************************
* FILE:          ListDataItem.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListDataItem is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ListDataItem_H)
#define ListDataItem_H

#include <vector>
#include <Candera/System/MemoryManagement/SharedPointer.h>
#include <CanderaPlatform/OS/CanderaTypes.h>
#include <CanderaWidget/String/String.h>
#include <Courier/Util/Identifier.h>
#include <Courier/Platform/AtomicOp.h>

#include "ServersData.h"
#include "IDataBindingUpdater.h"
#include "Widgets/2D/ControlTemplate/DataItem.h"

class ListDataItem;

typedef Candera::MemoryManagement::SharedPointer<ListDataItem> tSharedPtrListDataItem;
typedef tSharedPtrListDataItem tSharedPtrDataItem;

typedef std::vector<tSharedPtrListDataItem> tSharedPtrListDataItemVector;
typedef tSharedPtrListDataItemVector tSharedPtrDataItemVector;

//typedef std::vector<tSharedPtrListDataItem> tSharedPtrDataItemVector;	// deprecated

#define DataItem ListDataItem

class ListDataItem : public IDataItem
{
   public:
      FEATSTD_RTTI_DECLARATION();

      // static const ServersDataItemFlags Default = 0;
      // static const ServersDataItemFlags Expandable = 0x01;     // expanded, used  with dropdown
      // static const ServersDataItemFlags IsExpanded = 0x02;     // expanded or collapsed

      enum Type
      {
         IntegerValue,
         StringValue,
         VectorValue,
         DataBindingUpdater
      };

      static tSharedPtrListDataItem newDataItem(Candera::UInt32 intValue, ServersDataItemHdlRow hdl = 0, DataItemContext dataItemContext = "", ServersDataItemFlags flags = 0);

      static tSharedPtrListDataItem newDataItem(const Candera::String& strValue, ServersDataItemHdlRow hdl = 0, DataItemContext dataItemContext = "", ServersDataItemFlags flags = 0);

      static tSharedPtrListDataItem newDataItem(const std::vector<tSharedPtrListDataItem> vecValue, ServersDataItemHdlRow hdl = 0, DataItemContext dataItemContext = "", ServersDataItemFlags flags = 0);

      static tSharedPtrListDataItem newIdentifierItem(unsigned listId, ServersDataItemHdlRow hdlRow, ServersDataItemHdlCol hdlCol, ServersDataItemFlags flags = 0);

      static tSharedPtrListDataItem newDataItem(Courier::IDataBindingUpdater* value, ServersDataItemHdlRow hdl = 0, DataItemContext dataItemContext = "", ServersDataItemFlags flags = 0);

      ~ListDataItem();

      operator Candera::Int32() const;

      IDataItem& operator = (Candera::Int32 value);

      operator Candera::String() const;

      bool isVector() const;

      size_t size() const;

      tSharedPtrIDataItem operator[](size_t index) const;

      bool updateDataBindings(bool force);
      void dumpContent(int index, int layer = 0) const;

      Courier::IDataBindingUpdater* dataBindingUpdater() const;

      DataItemContext dataItemContext() const;

      Type type() const;

      tSharedPtrListDataItem cloneAs(DataItemContext dataItemContext) const;

      ServersDataItemFlags getFlags() const;
      void setFlags(ServersDataItemFlags fl);

      void setHdlRow(ServersDataItemHdlRow index);
      void setHdlCol(ServersDataItemHdlCol index);
      ServersDataItemHdlRow getHdlRow() const;
      ServersDataItemHdlCol getHdlCol() const;

      Courier::Identifier getIdent() const;

      virtual Candera::Int32 compare(const IDataItem& item);

      bool HasFlags(ServersDataItemFlags flags);

      void SetCollapsed(bool flag)
      {
         _isCollapsed = flag;
      }
      bool IsCollapsed() const
      {
         return _isCollapsed;
      }

   private:
      explicit ListDataItem(Courier::IDataBindingUpdater* value, DataItemContext dataItemContext, ServersDataItemHdlRow hdlRow, ServersDataItemFlags flags = 0);

      // constructor for integers, can used in column descriptions and as a one item row description
      explicit ListDataItem(Candera::UInt32 intValue, DataItemContext dataItemContext, ServersDataItemHdlRow hdlRow, ServersDataItemFlags flags = 0);

      // constructor for strings, can used in column descriptions and as a one item row description
      explicit ListDataItem(const Candera::String& strValue, DataItemContext dataItemContext, ServersDataItemHdlRow hdlRow, ServersDataItemFlags flags = 0);

      // constructor for column descriptions of one row
      explicit ListDataItem(const std::vector<tSharedPtrListDataItem>& vecValue, DataItemContext dataItemContext, ServersDataItemHdlRow hdlRow, ServersDataItemFlags flags = 0);

      // Identifier constructor for buttons etc
      explicit ListDataItem(unsigned listId, ServersDataItemHdlRow hdlRow, ServersDataItemHdlCol hdlCol, ServersDataItemFlags flags, int);

      ListDataItem(DataItemContext dataItemContext, const ListDataItem& item);

      // disallow copy constructor and operator=
      FEATSTD_MAKE_CLASS_UNCOPYABLE(ListDataItem);

      union ItemEntry
      {
         Candera::UInt32                     _intValue;
         Candera::String*                    _stringValue;
         std::vector<tSharedPtrListDataItem>* _vecValue;
         Courier::IDataBindingUpdater*       _dataBindingUpdater;
      };

      ItemEntry        _data;            // set of Items per row
      DataItemContext  _dataItemContext; // points to a template
      Type             _type;            // union type information
      ServersDataItemFlags  _flags;      // visible flags
      ServersDataItemHdlRow _hdlRow;     // points to a midw data item index
      ServersDataItemHdlCol _hdlCol;     // points to a midw data item index
      Courier::Identifier   _ident;      // used to detect the sender
      bool _isCollapsed;                 // whether or not the item is collapsed - default is false
      bool _intModified;                 // whether or not the integer value got modified
      bool _stringModified;              // whether or not the float value got modified
};


#endif
