/* ***************************************************************************************
* FILE:          AppListDataProviderCache.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AppListDataProviderCache.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "AppListDataProviderCache.h"
#include "Widgets/2D/List/ListWidget2D.h"
#include "Widgets/2D/List/Data/ListDataProvider.h"

namespace hmibase {
namespace widget {
AppListDataProviderCache& AppListDataProviderCache::getInstance()
{
   static AppListDataProviderCache instance;
   return instance;
}


AppListDataProviderCache::AppListDataProviderCache()
{
   setWidgetHandler();
}


AppListDataProviderCache::~AppListDataProviderCache()
{
   ListWidget2D::SetListDataProviderCache(0);
}


void AppListDataProviderCache::setWidgetHandler()
{
   ListWidget2D::SetListDataProviderCache(this);
}


bool AppListDataProviderCache::cacheList(unsigned long listID, const Courier::Message& message)
{
   // remove existing item and update it with a newer one
   FeatStd::Internal::CriticalSectionLocker csLock(&_critical);

   remove(listID);
   Courier::Message* pp = const_cast<Courier::Message*>(&message);
   Courier::MessageReferrer msgRef(pp);
   _msgList.Append(msgRef);
   return true;
}


bool AppListDataProviderCache::remove(unsigned long listID)
{
   for (tMsgRefList::Iterator it = _msgList.Begin(); it != _msgList.End(); ++it)
   {
      Courier::MessageReferrer msgRef = *it;
      const Courier::Message* lMsg = msgRef.GetMessage();
      const ListDateProviderResMsg* listDataResultMsg = static_cast<const ListDateProviderResMsg*>(lMsg);
      if (listDataResultMsg)
      {
         if (listDataResultMsg->GetListDateProvider()->listId() == listID)
         {
            _msgList.Remove(*it);
            it = _msgList.Begin();
            continue;
         }
      }
   }
   return false;
}


bool AppListDataProviderCache::checkForCachedData(unsigned long listID, Courier::MessageReferrer& msgRefReturn)
{
   FeatStd::Internal::CriticalSectionLocker csLock(&_critical);

   for (tMsgRefList::Iterator it = _msgList.Begin(); it != _msgList.End(); ++it)
   {
      Courier::MessageReferrer msgRef = *it;
      const Courier::Message* lMsg = msgRef.GetMessage();
      const ListDateProviderResMsg* listDataResultMsg = static_cast<const ListDateProviderResMsg*>(lMsg);
      if (listDataResultMsg)
      {
         if (listDataResultMsg->GetListDateProvider()->listId() == listID)
         {
            msgRefReturn = *it;
            //_msgList.Remove(*it);
            return true;
         }
      }
   }
   return false;
}


bool AppListDataProviderCache::onMessage(const Courier::Message& msg)
{
   bool consumed = false;
   switch (msg.GetId())
   {
      case ListDateProviderResMsg::ID:
      {
         const ListDateProviderResMsg* listDataProviderResMsg = Courier::message_cast<const ListDateProviderResMsg*>(&msg);
         if (listDataProviderResMsg != NULL && !listDataProviderResMsg->GetListDateProvider().PointsToNull() && listDataProviderResMsg->GetListDateProvider()->isCacheEnabled())
         {
            cacheList(listDataProviderResMsg->GetListDateProvider()->listId(), msg);
         }
      }
      break;
      default:
         break;
   }
   return consumed;
}


}
}
