/* ***************************************************************************************
* FILE:          ListWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "CustomListEnums.h"

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {

template<> ::FeatStd::UInt32 StringBufferAppender< ::ListMovementStatusType >::Append(::FeatStd::StringBuffer& stringBuffer, ::ListMovementStatusType const & object)
{
    ::FeatStd::UInt32 tcharCount = 0;
    switch (object) {
        case ::ListMovementFinished:
            tcharCount += stringBuffer.Append("::ListMovementFinished");
            break;
        case ::ListMovementItem:
            tcharCount += stringBuffer.Append("::ListMovementItem");
            break;
        case ::ListMovementPage:
            tcharCount += stringBuffer.Append("::ListMovementPage");
            break;
        case ::ListMovementSet:
            tcharCount += stringBuffer.Append("::ListMovementSet");
            break;
        case ::ListMovementScrolling:
            tcharCount += stringBuffer.Append("::ListMovementScrolling");
            break;
        case ::ListMovementSwiping:
            tcharCount += stringBuffer.Append("::ListMovementSwiping");
            break;
        case ::ListMovementSnap:
            tcharCount += stringBuffer.Append("::ListMovementSnap");
            break;
        default:
            tcharCount += stringBuffer.Append("##unknown##");
            break;
    }
    return tcharCount;
}

}
#endif

