/* ***************************************************************************************
* FILE:          TemplateRetriever.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TemplateRetriever is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(TemplateRetriever_H)
#define TemplateRetriever_H

#include <Widgets/2D/List/Content/ITemplateRetriever.h>

class TemplateRetriever : public ITemplateRetriever
{
   public:
      TemplateRetriever();
      virtual ~TemplateRetriever();

      virtual Candera::Node2D* GetTemplate(const tSharedPtrListDataItem& item) const override;
      virtual ListWidget2DBase::TemplateScrollAnimationType GetTemplateScrollAnimations() const override;
      virtual bool IsValid() const override;
      virtual void Accept(ITemplateVIsitor* visitor) const override;

      void SetTemplateGroup(Candera::Node2D* val);
      void SetInvalidItemTemplate(Candera::Node2D* val);
      void SetTemplateScrollAnimations(ListWidget2DBase::TemplateScrollAnimationType scrollAnimations);

      bool IsInvalidTemplate(Candera::Node2D* templateNode) const override;

   private:
      Candera::Node2D* _invalidItemTemplate;
      Candera::Node2D* _templateGroup;
      ListWidget2DBase::TemplateScrollAnimationType _templateScrollAnimations;
};


#endif
