/* ***************************************************************************************
* FILE:          TemplateRetriever.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TemplateRetriever is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "TemplateRetriever.h"


TemplateRetriever::TemplateRetriever() :
   _templateGroup(0),
   _invalidItemTemplate(0)
{
}


TemplateRetriever::~TemplateRetriever()
{
   _templateGroup = 0;
   _invalidItemTemplate = 0;
}


Candera::Node2D* TemplateRetriever::GetTemplate(const tSharedPtrListDataItem& item) const
{
   Candera::Node2D* templateNode(_invalidItemTemplate);
   if ((!item.PointsToNull()) && (0 != _templateGroup))
   {
      templateNode = _templateGroup->GetChild(item->dataItemContext());
      if (0 == templateNode)
      {
         templateNode = _invalidItemTemplate;
      }
   }

   return templateNode;
}


ListWidget2DBase::TemplateScrollAnimationType TemplateRetriever::GetTemplateScrollAnimations() const
{
   return _templateScrollAnimations;
}


bool TemplateRetriever::IsValid() const
{
   return (0 != _templateGroup) && (0 != _invalidItemTemplate);
}


void TemplateRetriever::SetTemplateGroup(Candera::Node2D* val)
{
   _templateGroup = val;
}


void TemplateRetriever::SetInvalidItemTemplate(Candera::Node2D* val)
{
   _invalidItemTemplate = val;
}


void TemplateRetriever::SetTemplateScrollAnimations(ListWidget2DBase::TemplateScrollAnimationType scrollAnimations)
{
   _templateScrollAnimations = scrollAnimations;
}


void TemplateRetriever::Accept(ITemplateVIsitor* visitor) const
{
   if (0 != visitor)
   {
      if (0 != _invalidItemTemplate)
      {
         visitor->Visit(*_invalidItemTemplate);
      }
      if (0 != _templateGroup)
      {
         Candera::Node2D* t(_templateGroup->GetFirstChild());

         while (0 != t)
         {
            visitor->Visit(*t);
            t = t->GetNextSibling();
         }
      }
   }
}


bool TemplateRetriever::IsInvalidTemplate(Candera::Node2D* templateNode) const
{
   return (templateNode == _invalidItemTemplate);
}
