/* ***************************************************************************************
* FILE:          SwipingListContentUpdater.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SwipingListContentUpdater is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(SwipingListContentUpdater_H)
#define SwipingListContentUpdater_H

#include "FlexPixelWiseAnimationManager.h"
#include "Widgets/2D/List/Layouting/FlexListLayouter.h"
#include "Widgets/2D/List/Content/Adders/ItemAdder.h"
#include "MaxIndexManager.h"
#include "Widgets/2D/Common/PagesInfo.h"
#include "Widgets/2D/List/Content/ListPagesInfo.h"
#include "ListContentUpdater.h"
#include "Widgets/2D/List/Content/Adders/PositionsCache.h"
#include "Widgets/2D/List/Content/ITemplateSpanAnalyzer.h"
#include "Widgets/2D/List/Content/ISizeContainer.h"
#include "Widgets/2D/List/Content/GridOccupation.h"
#include <Widgets/2D/List/Swiping/PositioningHandler.h>
#include <Widgets/2D/List/Swiping/SwipingStateChecker.h>
#include <Widgets/2D/List/Animations/ExpandTriggerManager.h>
#include "Widgets/2D/List/Content/Adders/AddingStrategy.h"
#include <Widgets/2D/ControlTemplate/ClonedItemCachingBehavior.h>
#include <Widgets/2D/ControlTemplate/ItemLayouter.h>
#include <Widgets/2D/List/Swiping/Normalizer.h>
#include <Widgets/2D/Common/OwnerInfoRetriever.h>
#include "SwipingListContentUpdaterListener.h"
#include "Widgets/2D/List/Content/ListContentAdder.h"
#include <Widgets/2D/List/Animations/ItemSpeedAnimationManager.h>

class ItemSizesContainer;
class SwipingListContentUpdater : public ListContentUpdater, public PositioningHandler, private FlexPixelWiseAnimationManagerListener
{
   public:
      typedef ListContentUpdater Base;

      SwipingListContentUpdater(const OwnerInfoRetriever& ownerInfoRetriever,
                                OrientationOperator& directOrientationOperator,
                                OrientationOperator& orthogonalOrientationOperator,
                                ControlTemplateInstanceContainer& itemsInstanceContainer,
                                ISizeContainer& sizesContainer,
                                ITemplateRetriever& templateRetriever,
                                const ContentProvider& contentProvider,
                                ItemSpeedAnimationManager& itemSpeedAnimationManager);
      virtual ~SwipingListContentUpdater();

      FEATSTD_LINT_NEXT_EXPRESSION(1511, "SwipingListContentUpdater derived classes also provide Init functions.")
      void Init(SwipingStateChecker* swipingStateChecker, ItemSizesContainer* itemSizesContainer, LayoutingListener* layoutingListener,
                Candera::Node2D* itemsGroup, const ListWidget2DBase::NumberOfItemsType& configuredNumberOfItems,
                TimeDispatcher* timeDispatcher);

      /******************************************************************************************/
      /* setter methods to keep the fields that corresponds to the widget properties up to date */
      /******************************************************************************************/
      void SetPixelWiseAnimationTime(const ListWidget2DBase::PixelWiseAnimationTimeType& time);
      void SetShortPixelWiseAnimationTime(const ListWidget2DBase::ShortPixelWiseAnimationTimeType& time);
      void SetAnimationManagerListenr(FlexPixelWiseAnimationManagerListener* listener);
      void SetCircular(bool val);
      void SetFixedPages(bool val);
      void SetPixelwise(bool val);
      void SetCoverflow(bool val);
      void SetPageWiseLockOut(bool val)
      {
         _pagewiseLockOut = val;
      }
      void SetListAlignment(Candera::ListAlignment::Enum listAlignment)
      {
         _listAlignment = listAlignment;
      }

      void SetPaddingArea(Candera::Margin paddingArea)
      {
         _paddingArea = paddingArea;
      }

      FeatStd::Int32 GetNumberOfVisibleItems() const
      {
         return _listItemAdder->GetNumberOfAddedItems();
      }
      /**
       *  Remaps the animation manager from the old to the new index.
       */
      void ForcePosition(Candera::UInt32 newIndex, Candera::UInt32 /*previousIndex*/);

      /**
       * @return the max position in order to fit all the elements
       */
      FeatStd::UInt32 GetMaxPosition() const;

      virtual void SetTargetStartIndex(ListWidget2DBase::StartIndexType startIndex);

      virtual void RefreshOnDataChanged();
      virtual void RefreshOnListItemExpandReqMsg();

      FeatStd::Int32 GetNumberOfCompletelyVisibleItems() const;

      FeatStd::UInt32 GetIndexOfFirstCompletelyVisibleElement() const;

      /**
       * @return the index of the first added element, even if it's not completely visible
       */
      FeatStd::Int32 GetFirstItemIndex() const;

      /**
      * @return the index of the last added element, even if it's not completely visible
      */
      FeatStd::Int32 GetLastItemIndex() const;

      const PagesInfo& GetPagesInfo() const;

      void SetTimeDispatcher(const Candera::Animation::AnimationTimeDispatcher::SharedPointer& val);

      void SetExpandTriggerManager(ExpandTriggerManager* expandTriggerManager)
      {
         _expandTriggerManager = expandTriggerManager;
      }

      virtual FeatStd::Float GetCurrentPosition() const override;
      virtual FeatStd::Float GetMaximumPosition() override;
      virtual FeatStd::Float GetMaximumSwipingPosition() const override;
      virtual bool IsCircular() const override;
      virtual void SetCurrentPosition(FeatStd::Float val) override;
      virtual void SetTargetPosition(FeatStd::Float val, bool finishCurrentAnimation = true) override;
      virtual void ResetMaximumPositions() override;

      void SetMovementDelay(FeatStd::Int32 delay);

      void SetDynamicGrid(bool flag);
      bool IsGrid() const;

      virtual void Finalize();

      void SetNormalizer(Normalizer* val);

      void SetDynamicGridEmptyCellsPolicy(DynamicGridEmptyCellsPolicyType::Enum val);

      void OnCustomAnimationsStopped();

      bool IsLastCompletelyVisible() const;

      void SetListener(SwipingListContentUpdaterListener* listener)
      {
         _listener = listener;
      }

      Candera::Int16 GetLastItemMargin() const
      {
         return _listItemAdder->GetLastItemMargin();
      }

      void UpdateMaxPositions();

   protected:
      virtual void DisposeContent();

   private:
      struct AdditionData
      {
         bool invalidItemsAdded;
         bool circularNeeded;
         bool lastItemCompletelyVisible;
         bool firstItemCompletelyVisible;
         bool pixelWiseEnabled;
         bool endReached;
         bool fillViewport;
         FeatStd::Int32 configuredNumberOfItems;
         FeatStd::Int32 numberOfItemsInFirstStructure;
         FeatStd::Int32 size;
         FeatStd::UInt32 previousVisibleItems;
         FeatStd::Float startIndex;
         FeatStd::Float position;
         FeatStd::Float scrollableSize;
         FeatStd::Float reversePositionCorrection;
         FeatStd::Float firstItemVisibleSize;
         FeatStd::Float lastItemInvisibleSize;
         FeatStd::Float firstItemMargin;
         FeatStd::Float lastItemMargin;
         FeatStd::Float sizeOfAddedElements;
      };

      /**
       *  Adds content to the list.
       * @return the index of the first added item
       */
      FeatStd::Int32 AddListContent(ListWidget2DBase::FocusedIndexType& focusedIndex, const Candera::Float position, const Candera::Vector2& visibleAreaInPixels, const ListWidget2DBase::PixelWiseScrollingEnabledType& pixelWiseEnabled);

      /**
       * returns true if circular scrolling is configured and needed; false otherwise. For example, if circular scrolling is configured,
       * but all the available items fit inside the viewport, circular scrolling is not needed
       */
      bool IsCircularNeeded() const;

      void CalculatePositionLimit(const FeatStd::Float position, const FeatStd::Float visibleSize, const bool endReached, const bool fillViewport);

      void CheckContentUpdated(const FeatStd::Int32 firstItemIndex, const FeatStd::Int32 lastItemIndex);

      Candera::Node2D* AddItem(FeatStd::UInt32 index, Candera::Float position, const Candera::Vector2& visibleAreaInPixels, bool& vacantVisibleArea, bool& invalidTemplate);
      Candera::Node2D* AddPixelWiseItem(Candera::Float position, FeatStd::UInt32 index, const Candera::Vector2& visibleAreaInPixels, bool& vacantVisibleArea, bool& invalidTemplate);
      Candera::Node2D* ReverseAddPixelWiseItem(Candera::Float position, FeatStd::UInt32 index, const Candera::Vector2& visibleAreaInPixels, bool& vacantVisibleArea, bool& invalidTemplate);

      /**
      * Extract node and template node from content provider.
      * It also set the node layouter.
      */
      bool ExtractItemNode(const FeatStd::Int32 index, Candera::Node2D*& node, Candera::Node2D*& templateNode);

      bool GetItemSize(const FeatStd::Int32 itemIndex, FeatStd::Float& size);

      Courier::ViewScene2D* GetCurrentViewScene();

      virtual bool UpdateListContent(ListWidget2DBase::StartIndexType& startIndex, ListWidget2DBase::FocusedIndexType& focusedIndex,
                                     ListWidget2DBase::NumberOfItemsType& numberOfItems,
                                     const Candera::Vector2& visibleAreaInPixels,
                                     ScrollingSpeed scrollingSpeed);

      void CollectPagesInfo();

      void AnalyzeTemplates();

      void UpdateAnimationTime(ScrollingSpeed scrollingSpeed);

      FeatStd::Float LimitPosition(FeatStd::Float val);

      virtual void OnAfterTemplateGroupChanged();
      virtual void OnAfterInvalidItemTemplateChanged();

      virtual void OnAnimationFinished();

      void UpdateLayouter();
      void UpdateAddingStrategy();
      void UpdateAdder();

      void Cache();

      // Viewport Padding methods
      void AddPreviousPaddingItems();
      void AddNextPaddingItems();

      ListContentAdder _scrollableContentAdder;
      ListContentAdder _paddingContentAdderPrevious;
      ListContentAdder _paddingContentAdderNext;
      const OwnerInfoRetriever& _ownerInfoRetriever;
      SwipingStateChecker* _swipingStateChecker;
      ItemSizesContainer* _itemSizesContainer;
      FlexPixelWiseAnimationManager _pixelWiseAnimationManager;
      FlexListLayouter* _itemsGroupLayouter;
      ItemAdder::SharedPointer _listItemAdder;
      ItemAdder::SharedPointer _paddingListItemAdderPrevious;
      ItemAdder::SharedPointer _paddingListItemAdderNext;
      MaxIndexManager _maxIndexManager;
      OrientationOperator& _orientationOperator;
      OrientationOperator& _orthogonalOrientationOperator;
      ListWidget2DBase::PixelWiseAnimationTimeType _pixelWiseAnimationTime;
      ListWidget2DBase::ShortPixelWiseAnimationTimeType _shortPixelwiseAnimationTime;
      FeatStd::Float _animTargetPosition;
      FeatStd::Int32 _indexOfFirstCompletelyVisibleElement;
      FeatStd::Int32 _firstItemIndex;
      FeatStd::Int32 _lastItemIndex;
      FeatStd::Int32 _previousLogicalStartIndex;
      FeatStd::Int32 _previousEndIndex;
      FeatStd::Float _positionLimit;
      bool _firstUpdateAfterNewData;
      FeatStd::Int32 _currentActualStartIndex;
      FeatStd::UInt32 _numberOfCompleteVisibleItems;
      FeatStd::Float _firstVisibleItemSize;
      bool _circular;
      FlexPixelWiseAnimationManagerListener* _animationManagerListener;
      bool _fixedPages;
      Candera::Vector2 _visibleArea;

      // variables related to viewport padding
      Candera::Margin _paddingArea;
      Candera::Vector2 _scrollableArea;
      Candera::Vector2 _previousPaddingArea;
      Candera::Vector2 _nextPaddingArea;

      bool _pixelwise;
      bool _shouldAnalyzeTemplates;
      bool _elementsShownOnlyOnce;
      AddingStrategy::SharedPointer _addingStrategy;
      ISizeContainer& _sizesContainer;
      bool _coverflow;
      bool _dynamicGrid;
      LayoutingListener* _layoutingListener;
      bool _pagewiseLockOut;
      Candera::ListAlignment::Enum _listAlignment;
      Candera::Animation::AnimationTimeDispatcher::SharedPointer _privateTimeDispatcher;
      ExpandTriggerManager* _expandTriggerManager;
      FeatStd::Int32 _oldVirtualListSize;
      FeatStd::UInt8 _preparedItemsBufferSize;
      FeatStd::UInt8 _preparedItemsUpdateTriggerOffset;
      ItemLayouter _itemLayouter;
      Normalizer* _normalizer;
      DynamicGridEmptyCellsPolicyType::Enum _dynamicGridEmptyCellsPolicy;
      SwipingListContentUpdaterListener* _listener;
      AdditionData _lastAdditionData;
      ListContentAdder::ListContentInfo _listInfo;
      ItemSpeedAnimationManager& _itemSpeedAnimationManager;
};


#endif
