/* ***************************************************************************************
* FILE:          SizeContainer.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SizeContainer is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(SizeContainer_H)
#define SizeContainer_H

#include <Widgets/2D/List/Content/ISizeContainer.h>
#include <map>
#include <Widgets/2D/List/Content/Adders/OrientationOperator.h>

class SizeContainer : public ISizeContainer
{
   public:
      SizeContainer();
      virtual ~SizeContainer();

      virtual Candera::Vector2 MeasureClientSize(Candera::Node2D* node) override;

      void Clear();

      void SetViewPort(Candera::Vector2 val)
      {
         _viewPort = val;
      }

   private:
      typedef std::map<const Candera::Node2D*, Candera::Vector2> SizeCache;

      SizeCache _itemsClientSizeCache;
      Candera::Vector2 _viewPort;
};


#endif
