/* ***************************************************************************************
* FILE:          SizeContainer.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SizeContainer is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "SizeContainer.h"

#include <Widgets/2D/Common/NodeHelper.h>

using namespace Candera;


SizeContainer::SizeContainer() :
   _viewPort(Math::MaxFloat(), Math::MaxFloat())
{
}


SizeContainer::~SizeContainer()
{
}


Candera::Vector2 SizeContainer::MeasureClientSize(Candera::Node2D* node)
{
   Vector2 itemSize;

   if (0 != node)
   {
      SizeCache::iterator cache(_itemsClientSizeCache.find(node));
      if (cache != _itemsClientSizeCache.end())
      {
         itemSize = cache->second;
      }
      else
      {
         itemSize = NodeHelper::GetSize(node, _viewPort);

         FEATSTD_LINT_NEXT_EXPRESSION(1963, "Intended use of value_type to avoid explicit type conversion.");
         static_cast<void>(_itemsClientSizeCache.insert(SizeCache::value_type(node, itemSize)));
      }
   }

   return itemSize;
}


void SizeContainer::Clear()
{
   _itemsClientSizeCache.clear();
}
