/* ***************************************************************************************
* FILE:          PageInfoCollectorWrapper.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PageInfoCollectorWrapper is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"

#include "PageInfoCollectorWrapper.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/PageInfoCollectorWrapper.cpp.trc.h"
#endif
#include "PageInfoCollector.h"


using namespace FeatStd;
using namespace Candera;

PageInfoCollectorWrapper::PageInfoCollectorWrapper(const ItemAdder::SharedPointer& adder) :
   _adder(adder)
{
}


void PageInfoCollectorWrapper::CollectPagesInfo(const ContentProvider& contentProvider,
      const AddChecker& addChecker,
      const ITemplateRetriever& templateRetriever,
      bool fixedPages,
      bool firstUpdateAfterNewData,
      FeatStd::Int32 indexOfFirstCompletelyVisibleElement,
      FeatStd::Int32 numberOfCompleteVisibleItems,
      bool circular,
      const Candera::Vector2 visibleArea)
{
   const FeatStd::Int32 virtualListSize(contentProvider.GetVirtualListSize());
   const FeatStd::Int32 windowElementSize(contentProvider.GetWindowElementSize());

   const bool allDataAvailable(virtualListSize <= windowElementSize);

   if (fixedPages && allDataAvailable)
   {
      if (firstUpdateAfterNewData)
      {
         CollectPageInfo(_fixedPagesInfo, 0, addChecker, contentProvider, templateRetriever, numberOfCompleteVisibleItems, circular, visibleArea);
         const Int32 lastPage(_fixedPagesInfo.GetPage(virtualListSize - 1));
         Int32 startIndexOfLastPage;
         _fixedPagesInfo.RetrieveStartIndexOfPage(lastPage, startIndexOfLastPage);
      }

      _pagesInfo = _fixedPagesInfo;

      const Int32 page(_fixedPagesInfo.GetPage(indexOfFirstCompletelyVisibleElement));
      _pagesInfo.Shift(-page);
   }
   else
   {
      CollectPageInfo(_pagesInfo, indexOfFirstCompletelyVisibleElement, addChecker, contentProvider, templateRetriever, numberOfCompleteVisibleItems, circular, visibleArea);
   }
}


const PagesInfo& PageInfoCollectorWrapper::GetPagesInfo() const
{
   return _pagesInfo;
}


void PageInfoCollectorWrapper::CollectPageInfo(ListPagesInfo& pagesInfo,
      const FeatStd::Int32 visibleStartInd,
      const AddChecker& addChecker,
      const ContentProvider& contentProvider,
      const ITemplateRetriever& templateRetriever,
      FeatStd::Int32 numberOfCompleteVisibleItems,
      bool circular,
      const Candera::Vector2 visibleArea)
{
   PageInfoCollector collector(pagesInfo,
                               templateRetriever,
                               addChecker,
                               _adder,
                               contentProvider,
                               visibleStartInd,
                               numberOfCompleteVisibleItems,
                               circular);

   collector.CollectPageInfo(visibleArea);
}
