/* ***************************************************************************************
* FILE:          PageInfoCollector.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PageInfoCollector is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(PageInfoCollector_H)
#define PageInfoCollector_H

#include <Widgets/2D/List/Content/ListPagesInfo.h>
#include <Widgets/2D/List/Content/ITemplateRetriever.h>
#include <Widgets/2D/List/Content/AddChecker.h>
#include <Widgets/2D/List/Content/Adders/ItemAdder.h>

class PageInfoCollector
{
   public:
      PageInfoCollector(ListPagesInfo& pagesInfo,
                        const ITemplateRetriever& templateRetriever,
                        const AddChecker& addChecker,
                        ItemAdder::SharedPointer itemAdder,
                        const ContentProvider& contentProvider,
                        FeatStd::Int32 visualStartIndex,
                        FeatStd::Int32 numberOfVisibleItems,
                        bool circular);

      void CollectPageInfo(const Candera::Vector2& visibleAreaInPixels);

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(PageInfoCollector);

      ListPagesInfo& _pagesInfo;
      const ITemplateRetriever& _templateRetriever;
      const AddChecker& _addChecker;
      ItemAdder::SharedPointer _itemAdder;
      const ContentProvider& _contentProvider;
      FeatStd::Int32 _visualStartIndex;
      FeatStd::Int32 _numberOfVisibleItems;
      bool _circular;

      void CollectPageInfoForPrevious(ItemAdder& itemAdder, const FeatStd::Int32 startIndex, const Candera::Vector2& visibleAreaInPixels);
      void CollectPageInfoForNext(ItemAdder& itemAdder, const FeatStd::Int32 pastEndIndex, const Candera::Vector2& visibleAreaInPixels);
};


#endif
