/* ***************************************************************************************
* FILE:          ListPagesInfo.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListPagesInfo is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ListPagesInfo_H
#define ListPagesInfo_H

#include <Widgets/2D/Common/PagesInfo.h>
#include <Candera/System/Container/Vector.h>

class ListPagesInfo : public PagesInfo
{
   public:
      ListPagesInfo();
      virtual ~ListPagesInfo();

      void Clear();
      void RecordCurrentPageSize(FeatStd::Int32 val);
      void RecordPageStartIndex(FeatStd::Int32 pageIndex, FeatStd::Int32 val);

      virtual bool RetrieveStartIndexOfPage(const FeatStd::Int32 pageIndex, FeatStd::Int32& startIndex) const;
      virtual FeatStd::Int32 GetStartIndexOfLastPage() const override;

      FeatStd::Int32 GetPage(FeatStd::Int32 startIndex) const;
      void Shift(FeatStd::Int32 offset);

   private:
      struct Info
      {
         Info(FeatStd::Int32 pageIndex, FeatStd::Int32 startIndex) :
            _pageIndex(pageIndex),
            _startIndex(startIndex)
         { }

         FeatStd::Int32 _pageIndex;
         FeatStd::Int32 _startIndex;
      };

      struct PageComparer
      {
         static FeatStd::Int Compare(Info left, Info right);
      };

      struct StartIndexComparer
      {
         static FeatStd::Int Compare(Info left, Info right);
      };

      typedef Candera::Internal::Vector<Info> PageStartIndices;

      PageStartIndices _pageStartIndices;
      FeatStd::Int32 _currentPageSize;
};


#endif
