/* ***************************************************************************************
* FILE:          ItemSizesContainer.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ItemSizesContainer is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ItemSizesContainer_H)
#define ItemSizesContainer_H

#include <Candera/System/Container/Vector.h>

class ItemSizesContainer
{
   public:
      typedef Candera::Internal::Vector<FeatStd::Float> SizesVector;

      virtual ~ItemSizesContainer() { }

      virtual void SetItemsSizes(const SizesVector& val) = 0;
      virtual const SizesVector& GetItemsSizes() const = 0;

      virtual FeatStd::Float GetTotalSize() const = 0;
};


#endif
