/* ***************************************************************************************
* FILE:          ITemplateSpanAnalyzer.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ITemplateSpanAnalyzer is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ITemplateSpanAnalyzer_H)
#define ITemplateSpanAnalyzer_H

#include <Candera/Engine2D/Core/Node2D.h>
#include <Widgets/2D/List/Content/ITemplateRetriever.h>

class ITemplateSpanAnalyzer
{
   public:
      FEATSTD_TYPEDEF_SHARED_POINTER(ITemplateSpanAnalyzer);

      virtual ~ITemplateSpanAnalyzer() { }

      virtual void Analyze(const ITemplateRetriever& templateRetriever) = 0;

      virtual Candera::Vector2 GetSpan(const Candera::Node2D* t) const = 0;

      virtual Candera::Vector2 GetSpanUnitSize() const = 0;

      virtual Candera::Vector2 GetMaxSpan() const = 0;

   private:
      FEATSTD_SHARED_POINTER_DECLARATION();
};


#endif
