/* ***************************************************************************************
* FILE:          GridOccupation.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GridOccupation is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(GridOccupation_H)
#define GridOccupation_H

#include <FeatStd/Platform/Types.h>
#include <Candera/System/Container/Vector.h>

class GridOccupation
{
   public:
      struct Coordinates
      {
         Coordinates();
         Coordinates(FeatStd::Int32 x, FeatStd::Int32 y);

         bool operator==(const Coordinates& other) const;
         bool operator!=(const Coordinates& other) const;
         Coordinates operator+(const Coordinates& other) const;
         Coordinates operator+=(const Coordinates& other) const;

         FeatStd::Int32 _x;
         FeatStd::Int32 _y;
      };

      GridOccupation();
      virtual ~GridOccupation();

      void SetAbsoluteStart(FeatStd::Int32 startX, FeatStd::Int32 startY);
      Coordinates GetAbsoluteStart() const;

      void Occupy(FeatStd::Int32 startX, FeatStd::Int32 startY, FeatStd::Int32 width, FeatStd::Int32 height);
      const Coordinates GetItemStart(FeatStd::Int32 column, FeatStd::Int32 row) const;
      bool IsOccupied(FeatStd::Int32 column, FeatStd::Int32 row) const;

      void Clear();

   private:
      typedef Candera::Internal::Vector < Coordinates > CoordinatesVector;
      typedef Candera::Internal::Vector< CoordinatesVector > CoordinatesMatrix;

      CoordinatesMatrix _occupancy;
      Coordinates _absoluteStart;

      void AssureOccupancyCapacity(FeatStd::Int32 totalWidth, FeatStd::Int32 totalHeight);
};


#endif
