/* ***************************************************************************************
* FILE:          GridOccupation.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GridOccupation is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/Layouter.h>
#else
#include <Candera/Engine2D/Layout/Layouter.h>
#endif

#include <Candera/System/Mathematics/Math.h>

#include "GridOccupation.h"


using namespace Candera;


GridOccupation::GridOccupation() :
   _absoluteStart(0, 0)
{
}


GridOccupation::~GridOccupation()
{
}


void GridOccupation::SetAbsoluteStart(FeatStd::Int32 startX, FeatStd::Int32 startY)
{
   _absoluteStart = Coordinates(startX, startY);
}


GridOccupation::Coordinates GridOccupation::GetAbsoluteStart() const
{
   return _absoluteStart;
}


void GridOccupation::Occupy(FeatStd::Int32 startX, FeatStd::Int32 startY, FeatStd::Int32 width, FeatStd::Int32 height)
{
   AssureOccupancyCapacity(startX + width, startY + height);

   for (Int32 x(0); x < width; ++x)
   {
      for (Int32 y(0); y < height; ++y)
      {
         _occupancy[startX + x][startY + y] = Coordinates(startX, startY);
      }
   }
}


const GridOccupation::Coordinates GridOccupation::GetItemStart(FeatStd::Int32 column, FeatStd::Int32 row) const
{
   Coordinates coordinates;

   if ((0 <= column) && (column < (FeatStd::Int32) _occupancy.Size()) && (0 <= row) && (row < (FeatStd::Int32) _occupancy[column].Size()))
   {
      coordinates = _occupancy[column][row];
   }

   return coordinates;
}


bool GridOccupation::IsOccupied(FeatStd::Int32 column, FeatStd::Int32 row) const
{
   static Coordinates empty;
   return GetItemStart(column, row) != empty;
}


void GridOccupation::AssureOccupancyCapacity(FeatStd::Int32 totalWidth, FeatStd::Int32 totalHeight)
{
   Int32 maxWidth(Math::Maximum(totalWidth, static_cast<Int32>(_occupancy.Size())));

   _occupancy.Reserve(maxWidth);
   for (Int32 i(0); i < maxWidth; ++i)
   {
      if (i >= static_cast<Int32>(_occupancy.Size()))
      {
         _occupancy.Add(CoordinatesVector());
      }

      Int32 maxHeight(Math::Maximum(totalHeight, static_cast<Int32>(_occupancy[i].Size())));
      _occupancy[i].Reserve(maxHeight);
      for (Int32 j(_occupancy[i].Size()); j < maxHeight; ++j)
      {
         _occupancy[i].Add(Coordinates());
      }
   }
}


void GridOccupation::Clear()
{
   _occupancy.Clear();
   _absoluteStart = Coordinates(0, 0);
}


GridOccupation::Coordinates::Coordinates() :
   _x(-1),
   _y(-1)
{
}


GridOccupation::Coordinates::Coordinates(FeatStd::Int32 x, FeatStd::Int32 y) :
   _x(x),
   _y(y)
{
}


GridOccupation::Coordinates GridOccupation::Coordinates::operator+(const Coordinates& other) const
{
   Coordinates res;
   res._x = _x + other._x;
   res._y = _y + other._y;
   return res;
}


GridOccupation::Coordinates GridOccupation::Coordinates::operator+=(const Coordinates& other) const
{
   return *this + other;
}


bool GridOccupation::Coordinates::operator==(const Coordinates& other) const
{
   return (_x == other._x) && (_y == other._y);
}


bool GridOccupation::Coordinates::operator!=(const Coordinates& other) const
{
   return !(*this == other);
}
