/* ***************************************************************************************
* FILE:          DefaultSwipingListContentUpdaterListener.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultSwipingListContentUpdaterListener is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(DefaultSwipingListContentUpdaterListener_H)
#define DefaultSwipingListContentUpdaterListener_H

#include "SwipingListContentUpdaterListener.h"
#include <Widgets/2D/List/Content/SizeContainer.h>

class DefaultSwipingListContentUpdaterListener : public SwipingListContentUpdaterListener
{
   public:
      DefaultSwipingListContentUpdaterListener();
      virtual ~DefaultSwipingListContentUpdaterListener();

      void SetSizeContainer(SizeContainer* sizeContainer)
      {
         _sizeContainer = sizeContainer;
      }

      virtual void OnPreItemAdd(FeatStd::Int32 addItems) override;

   private:
      SizeContainer* _sizeContainer;
};


#endif
