/* ***************************************************************************************
* FILE:          DefaultSwipingListContentUpdaterListener.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultSwipingListContentUpdaterListener is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"

#include "DefaultSwipingListContentUpdaterListener.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/DefaultSwipingListContentUpdaterListener.cpp.trc.h"
#endif

DefaultSwipingListContentUpdaterListener::DefaultSwipingListContentUpdaterListener() :
   _sizeContainer(0)
{
}


DefaultSwipingListContentUpdaterListener::~DefaultSwipingListContentUpdaterListener()
{
   _sizeContainer = 0;
}


void DefaultSwipingListContentUpdaterListener::OnPreItemAdd(FeatStd::Int32 addItems)
{
   if (addItems == 0)
   {
      if (_sizeContainer != 0)
      {
         _sizeContainer->Clear();
      }
   }
}
