/* ***************************************************************************************
* FILE:          DefaultListContentUpdater.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultListContentUpdater is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(DefaultListContentUpdater_H)
#define DefaultListContentUpdater_H

#include "ListContentUpdater.h"

class DefaultListContentUpdater : public ListContentUpdater
{
   public:
      DefaultListContentUpdater(ControlTemplateInstanceContainer& itemsInstanceContainer,
                                ITemplateRetriever& templateRetriever,
                                const ContentProvider& contentProvider);

      Candera::Node2D* AddItem(const tSharedPtrListDataItem& source, FeatStd::UInt32 index);

      virtual FeatStd::Float GetCurrentPosition() const;

      /**
       * @return the max position in order to fit all the elements
       */
      virtual FeatStd::UInt32 GetMaxPosition() const;

      virtual void SetTargetStartIndex(ListWidget2DBase::StartIndexType /*startIndex*/);

      virtual void RefreshOnDataChanged();

   private:
      virtual bool UpdateListContent(ListWidget2DBase::StartIndexType& startIndex, ListWidget2DBase::FocusedIndexType& focusedIndex,
                                     ListWidget2DBase::NumberOfItemsType& numberOfItems,
                                     const Candera::Vector2& visibleAreaInPixels,
                                     ScrollingSpeed scrollingSpeed);
};


#endif
