/* ***************************************************************************************
* FILE:          DefaultListContentUpdater.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultListContentUpdater is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "DefaultListContentUpdater.h"


using namespace Candera;


DefaultListContentUpdater::DefaultListContentUpdater(ControlTemplateInstanceContainer& itemsInstanceContainer,
      ITemplateRetriever& templateRetriever,
      const ContentProvider& contentProvider) :
   ListContentUpdater(itemsInstanceContainer, templateRetriever, contentProvider)
{
}


Candera::Node2D* DefaultListContentUpdater::AddItem(const tSharedPtrListDataItem& source, FeatStd::UInt32 index)
{
   Candera::Node2D* itemNode = 0;
   Candera::Node2D* itemsGroup(GetItemsGroup());

   if ((0 != itemsGroup))
   {
      itemNode = _itemsInstanceContainer.AddControlTemplateClone(_templateRetriever, source, index);
      if (0 != itemNode)
      {
         itemNode->SetRenderingEnabled(true);
         static_cast<void>(itemsGroup->AddChild(itemNode));
         static_cast<void>(itemNode->Upload(ScopeMask(), Candera::Node2D::Deep));
      }
   }

   return itemNode;
}


FeatStd::Float DefaultListContentUpdater::GetCurrentPosition() const
{
   return 0;
}


FeatStd::UInt32 DefaultListContentUpdater::GetMaxPosition() const
{
   return 0; /* to be implemented*/
}


void DefaultListContentUpdater::SetTargetStartIndex(ListWidget2DBase::StartIndexType /*startIndex*/)
{
   // do nothing;
}


void DefaultListContentUpdater::RefreshOnDataChanged()
{
}


bool DefaultListContentUpdater::UpdateListContent(ListWidget2DBase::StartIndexType& startIndex, ListWidget2DBase::FocusedIndexType& focusedIndex,
      ListWidget2DBase::NumberOfItemsType& numberOfItems,
      const Candera::Vector2& /*visibleAreaInPixels = Candera::Vector2(0.0, 0.0)*/,
      ScrollingSpeed /*scrollingSpeed*/)
{
   _focusedItem = 0;
   Candera::Node2D* itemGroup(GetItemsGroup());
   ContentProvider contentProvider(GetContentProvider());

   if ((0 != itemGroup) && (contentProvider.HasItems()))
   {
      DisposeContent();

      Int32 indexOffset = contentProvider.GetStartIndex();
      Int32 size = contentProvider.GetVirtualListSize();

      for (Int32 i = 0; (i < Candera::Int32(numberOfItems)) && (Candera::Int32(startIndex) + i < size); ++i)
      {
         Int32 index = i + indexOffset;
         UInt32 itemIndex = startIndex + static_cast<UInt32>(i);
         bool itemInvalid = true;
         Candera::Node2D* itemNode = 0;
         const tSharedPtrListDataItem& current = contentProvider.GetItem(index);
         if (!current.PointsToNull())
         {
            itemInvalid = false;
            itemNode = AddItem(current, itemIndex);
         }
         if (itemInvalid)
         {
            itemNode = AddItem(tSharedPtrListDataItem(), itemIndex);
         }
         if (Candera::Int32(startIndex) + i == focusedIndex)
         {
            _focusedItem = itemNode;
         }
      }
   }

   return false;
}
