/* ***************************************************************************************
* FILE:          StackAddingStrategy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  StackAddingStrategy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(StackAddingStrategy_H)
#define StackAddingStrategy_H

#include "FeatStd/MemoryManagement/SharedPointer.h"
#include "ItemAdder.h"
#include "PositionsCalculator.h"
#include "AddingStrategy.h"
#include "DefaultPositionsCalculator.h"
#include "Widgets/2D/List/Content/PageInfoCollectorWrapper.h"

class StackAddingStrategy : public AddingStrategy
{
      FEATSTD_TYPEDEF_BASE(AddingStrategy);

   public:
      FEATSTD_TYPEDEF_SHARED_POINTER(StackAddingStrategy);

      static StackAddingStrategy::SharedPointer Create(ISizeContainer& sizesContainer, const OrientationOperator& directOrientationOperator, const OrientationOperator& orthogonalOrientationOperator, const bool& coverflow);

      virtual bool SupportsViewportPadding()
      {
         return true;
      }

   private:
      StackAddingStrategy(ISizeContainer& sizesContainer, const OrientationOperator& directOrientationOperator, const OrientationOperator& orthogonalOrientationOperator, const bool& coverflow);

      DefaultPositionsCalculator _calculator;
      const bool& _coverflow;
      PageInfoCollectorWrapper _infoCollector;

      virtual const PositionsCalculator& GetPositionsCalculator() const override;
      virtual ItemAdder::SharedPointer CreateItemAdderImpl(Candera::Node2D* groupNode) override;

      virtual void CollectPagesInfoImpl(const ContentProvider& contentProvider,
                                        const AddChecker& addChecker,
                                        const ITemplateRetriever& templateRetriever,
                                        bool fixedPages,
                                        bool firstUpdateAfterNewData,
                                        FeatStd::Int32 indexOfFirstCompletelyVisibleElement,
                                        FeatStd::Int32 numberOfCompleteVisibleItems,
                                        bool circular,
                                        const Candera::Vector2 visibleArea) override;

      virtual const PagesInfo& GetPagesInfoImpl() const override;
};


#endif
