/* ***************************************************************************************
* FILE:          SpanInfo.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SpanInfo is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(SpanInfo_H)
#define SpanInfo_H

#include <FeatStd/Platform/Types.h>

class SpanInfo
{
   public:
      SpanInfo(FeatStd::Int8 span, FeatStd::Int32 index);

      SpanInfo(const SpanInfo& other);

      SpanInfo& operator=(const SpanInfo& other);

      bool operator==(const SpanInfo& other) const;

      bool operator<(const SpanInfo& other) const;

      FeatStd::Int8 GetSpan() const
      {
         return _span;
      }
      FeatStd::Int32 GetIndex() const
      {
         return _index;
      }
   private:
      FeatStd::Int8 _span;
      FeatStd::Int32 _index;
};


#endif
