/* ***************************************************************************************
* FILE:          SpanInfo.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SpanInfo is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "SpanInfo.h"


SpanInfo::SpanInfo(FeatStd::Int8 span, FeatStd::Int32 index) :
   _span(span),
   _index(index)
{
}


SpanInfo::SpanInfo(const SpanInfo& other) :
   _span(other.GetSpan()),
   _index(other.GetIndex())
{
}


SpanInfo& SpanInfo::operator=(const SpanInfo& other)
{
   if (this != &other)
   {
      _span = other._span;
      _index = other._index;
   }

   return *this;
}


bool SpanInfo::operator==(const SpanInfo& other) const
{
   return GetSpan() == other.GetSpan();
}


bool SpanInfo::operator<(const SpanInfo& other) const
{
   return GetSpan() < other.GetSpan();
}
