/* ***************************************************************************************
* FILE:          OrthoItemArranger.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OrthoItemArranger is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(OrthoItemArranger_H)
#define OrthoItemArranger_H

#include "OrthoGridPageInfoCollection.h"
#include "OrthoGridPageInfo.h"
#include "OrientationOperator.h"
#include "OrthoGridEmptyCellsPolicy.h"

class OrthoItemArranger
{
   public:
      OrthoItemArranger(const OrientationOperator& directOrientationOperator,
                        const OrientationOperator& orthogonalOrientationOperator,
                        Candera::UInt32& numberOfCompleteVisibleItems,
                        OrthoGridPageInfoCollection& pagesInfo,
                        OrthoGridPageInfo& page0,
                        OrthoGridPageInfo& page1,
                        Candera::Node2D* firstItem,
                        FeatStd::Int32 maxOrthogonalItemsCount,
                        FeatStd::Int32 itemIndex,
                        FeatStd::Int32 structureOffset,
                        bool newPage0,
                        bool newPage1);

      void Layout(Courier::Vector<FeatStd::Int8> spans,
                  FeatStd::UInt32 structIndex,
                  FeatStd::UInt32 pageIndex,
                  FeatStd::Int32 numberOfCells,
                  FeatStd::Int32 startPosition,
                  FeatStd::Float deltaPosition,
                  FeatStd::UInt32 sizesCount);

      void FinishLayout(FeatStd::Int32 pageIndex);

      bool HasNextItem() const
      {
         return _item != 0;
      }

      FeatStd::Int8 GetMaxRelPos() const
      {
         return _maxRelPos;
      }

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(OrthoItemArranger);

      const OrientationOperator& _directOrientationOperator;
      const OrientationOperator& _orthogonalOrientationOperator;
      FeatStd::Int8 _relPos;
      FeatStd::Int8 _orthoPos;
      FeatStd::Int8 _maxRelPos;
      Candera::Node2D* _item;
      FeatStd::Int32 _itemIndex;
      FeatStd::Int32 _structureOffset;
      FeatStd::Int32 _maxOrthogonalItemsCount;
      Candera::UInt32& _numberOfCompleteVisibleItems;
      bool _newPage0;
      bool _newPage1;
      OrthoGridPageInfoCollection& _pagesInfo;
      OrthoGridPageInfo& _page0;
      OrthoGridPageInfo& _page1;

      void LayoutItems(FeatStd::Internal::Vector<FeatStd::Int8>& spans,
                       FeatStd::UInt32 structIndex,
                       FeatStd::UInt32 pageIndex,
                       FeatStd::Int32 numberOfCells,
                       FeatStd::Int32 startPosition,
                       FeatStd::Float deltaPosition);
      void ComputeMaxRelPosition();
      bool IsPageEnd(FeatStd::UInt32 structIndex, FeatStd::UInt32 pageIndex, FeatStd::UInt32 sizesCount);
      void EndPage0(bool pageEnd, FeatStd::UInt32 pageIndex);
      void EndPage1(bool pageEnd, FeatStd::UInt32 pageIndex);
};


#endif
