/* ***************************************************************************************
* FILE:          OrthoGridPageInfo.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OrthoGridPageInfo is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "OrthoGridPageInfo.h"

using namespace FeatStd;

OrthoGridPageInfo::OrthoGridPageInfo() :
   _startStructIndex(-1),
   _endStructIndex(-1),
   _startItemIndex(-1),
   _endItemIndex(-1)
{
}


void OrthoGridPageInfo::SetStartItemIndex(FeatStd::Int32 val)
{
   _startItemIndex = val;
}


void OrthoGridPageInfo::SetEndItemIndex(FeatStd::Int32 val)
{
   _endItemIndex = val;
}


void OrthoGridPageInfo::SetStructureIndices(FeatStd::Int32 begining, FeatStd::Int32 ending)
{
   _startStructIndex = begining;
   _endStructIndex = ending;
}


void OrthoGridPageInfo::RetainItemLayout(FeatStd::Int32 beginingDirectStruct, FeatStd::Int32 beginingOrthoStruct, FeatStd::Int32 directSpan, FeatStd::Int32 orthoSpan, FeatStd::Int32 itemIndex)
{
   beginingDirectStruct -= _startStructIndex;

   for (SizeType i(beginingDirectStruct); i < (beginingDirectStruct + directSpan); ++i)
   {
      while (i >= _structuresInfo.Size())
      {
         _structuresInfo.Add(IndicesCollection());
      }

      IndicesCollection& indices(_structuresInfo[i]);
      for (SizeType j(beginingOrthoStruct); j < (beginingOrthoStruct + orthoSpan); ++j)
      {
         while (j >= indices.Size())
         {
            indices.Add(-1);
         }

         indices[j] = itemIndex;
      }
   }
}


bool OrthoGridPageInfo::ContainsItemIndex(FeatStd::Int32 itemIndex) const
{
   return (_startItemIndex <= itemIndex) && (itemIndex <= _endItemIndex);
}


bool OrthoGridPageInfo::ContainsStructIndex(FeatStd::Int32 structIndex) const
{
   return (_startStructIndex <= structIndex) && (structIndex <= _endStructIndex);
}


FeatStd::Int32 OrthoGridPageInfo::GetStructureIndex(FeatStd::Int32 itemIndex) const
{
   FeatStd::Int32 structureStart(-1);

   for (SizeType i(0); (structureStart == -1) && (i < _structuresInfo.Size()); ++i)
   {
      const IndicesCollection& indices(_structuresInfo[i]);
      for (SizeType j(0); (structureStart == -1) && (j < indices.Size()); ++j)
      {
         if (indices[j] == itemIndex)
         {
            structureStart = i;
         }
      }
   }

   return _startStructIndex + structureStart;
}


FeatStd::Int32 OrthoGridPageInfo::GetStartIndex(FeatStd::Int32 structIndex) const
{
   return _structuresInfo[structIndex - _startStructIndex][0];
}


FeatStd::Int32 OrthoGridPageInfo::GetStartStructIndex() const
{
   return _startStructIndex;
}


FeatStd::Int32 OrthoGridPageInfo::GetEndStructIndex() const
{
   return _endStructIndex;
}


FeatStd::Int32 OrthoGridPageInfo::GetStartItemIndex() const
{
   return _startItemIndex;
}


FeatStd::Int32 OrthoGridPageInfo::GetEndItemIndex() const
{
   return _endItemIndex;
}


bool OrthoGridPageInfo::IsEmpty() const
{
   return (_startStructIndex == -1) && (_endStructIndex == -1) && (_startItemIndex == -1) && (_endItemIndex == -1);
}
