/* ***************************************************************************************
* FILE:          OrthoGridEmptyCellsPolicy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OrthoGridEmptyCellsPolicy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef OrthoGridEmptyCellsPolicy_H
#define OrthoGridEmptyCellsPolicy_H

#include "FeatStd/Platform/Types.h"
#include "Courier/Util/Vector.h"
#include "SpanInfo.h"
#include "FeatStd/MemoryManagement/SharedPointer.h"

class OrthoGridEmptyCellsPolicy
{
   public:
      FEATSTD_TYPEDEF_SHARED_POINTER(OrthoGridEmptyCellsPolicy);

      virtual ~OrthoGridEmptyCellsPolicy() { }

      virtual void AdjustSpans(const FeatStd::Int32 deltaSpan, Courier::Vector<FeatStd::Int8>& spans, const Courier::Vector<SpanInfo>& orderedSpans) = 0;

   protected:
      OrthoGridEmptyCellsPolicy() { }

   private:
      FEATSTD_SHARED_POINTER_DECLARATION();
};


#endif
