/* ***************************************************************************************
* FILE:          OrthoCellResolver.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OrthoCellResolver is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(OrthoCellResolver_H)
#define OrthoCellResolver_H

#include <Courier/Util/Vector.h>
#include "OrthoGridEmptyCellsPolicy.h"

class OrthoCellResolver
{
   public:
      typedef Courier::Vector<FeatStd::Float> SizesCollection;
      typedef Courier::Vector<SizesCollection> SizesBidimensionalCollections;

      OrthoCellResolver(OrthoGridEmptyCellsPolicy::SharedPointer emptyCellsPolicy, SizesBidimensionalCollections& sizes);

      Courier::Vector<FeatStd::Int8> CalculateSpans(FeatStd::Float visibleSize, FeatStd::Float currentMinCellSize, FeatStd::Int32 numberOfCells, FeatStd::UInt32 structIndex);

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(OrthoCellResolver);

      OrthoGridEmptyCellsPolicy::SharedPointer _emptyCellsPolicy;
      SizesBidimensionalCollections& _sizes;
      Courier::Vector<FeatStd::Int8> _spans;
      Courier::Vector<SpanInfo> _orderedSpans;
      FeatStd::Int32 _totalSpan;
      FeatStd::Float _newStructureSize;
      FeatStd::UInt32 _index;

      void AdjustSpans(FeatStd::Int32 numberOfCells);
      void FitItems(const SizesCollection& structureSizes, FeatStd::Float visibleSize, FeatStd::Float currentMinCellSize, FeatStd::Int32 numberOfCells);
      void DistributeToNextStructure(FeatStd::UInt32 structureSizesCount, FeatStd::UInt32 structIndex, FeatStd::Float visibleSize);
};


#endif
