/* ***************************************************************************************
* FILE:          GridPositionsCalculator.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GridPositionsCalculator is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(GridPositionsCalculator_H)
#define GridPositionsCalculator_H

#include "PositionsCalculator.h"
#include "PositionsCache.h"
#include "OrientationOperator.h"
#include "GridItemAdder.h"


class GridPositionsCalculator : public PositionsCalculator
{
      FEATSTD_TYPEDEF_BASE(PositionsCalculator);
   public:
      GridPositionsCalculator(const GridItemAdder::SharedPointer& adder, const ITemplateSpanAnalyzer::SharedPointer& templateSpanAnalyzer, const PositionsCache& positionsCache, const OrientationOperator& orthogonalOrientationOperator);
      virtual ~GridPositionsCalculator();

      virtual FeatStd::Float CalculateStartingPosition(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::UInt32 startIndex) const override;

      virtual FeatStd::Int32 CalculateStartIndex(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::Float position) const override;

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(GridPositionsCalculator);

      GridItemAdder::SharedPointer _adder;
      ITemplateSpanAnalyzer::SharedPointer _templateSpanAnalyzer;
      const PositionsCache& _positionsCache;
      const OrientationOperator& _orthogonalOrientationOperator;

      PositionsCache::CacheData AdjustStartingPositionsByStartIndex(Candera::Node2D& invalidTemplate, const ContentProvider& contentProvider, const Candera::UInt32 startIndex) const;
      PositionsCache::CacheData AdjustStartingPositionsByStructureIndex(Candera::Node2D& invalidTemplate, const ContentProvider& contentProvider, const Candera::UInt32 structureIndex) const;
};


#endif
