/* ***************************************************************************************
* FILE:          DistributeToLastItemOGEmptyCellsPolicy.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DistributeToLastItemOGEmptyCellsPolicy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "DistributeToLastItemOGEmptyCellsPolicy.h"

using namespace FeatStd;

DistributeToLastItemOGEmptyCellsPolicy::SharedPointer DistributeToLastItemOGEmptyCellsPolicy::Create()
{
   return  DistributeToLastItemOGEmptyCellsPolicy::SharedPointer(FEATSTD_NEW(DistributeToLastItemOGEmptyCellsPolicy));
}


void DistributeToLastItemOGEmptyCellsPolicy::AdjustSpans(const FeatStd::Int32 deltaSpan, Courier::Vector<FeatStd::Int8>& spans, const Courier::Vector<SpanInfo>& /*orderedSpans*/)
{
   SizeType lastIndex(spans.Size() - 1);
   if (spans.Size() >= 1)
   {
      spans[lastIndex] += deltaSpan;
   }
}


DistributeToLastItemOGEmptyCellsPolicy::DistributeToLastItemOGEmptyCellsPolicy()
{
}
