/* ***************************************************************************************
* FILE:          DistributeToAllItemsOGEmptyCellsPolicy.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DistributeToAllItemsOGEmptyCellsPolicy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "DistributeToAllItemsOGEmptyCellsPolicy.h"
#include "Candera/System/Mathematics/Math.h"

using namespace FeatStd;
using namespace Candera;

DistributeToAllItemsOGEmptyCellsPolicy::SharedPointer DistributeToAllItemsOGEmptyCellsPolicy::Create()
{
   return  DistributeToAllItemsOGEmptyCellsPolicy::SharedPointer(FEATSTD_NEW(DistributeToAllItemsOGEmptyCellsPolicy));
}


void DistributeToAllItemsOGEmptyCellsPolicy::AdjustSpans(const FeatStd::Int32 deltaSpan, Courier::Vector<FeatStd::Int8>& spans, const Courier::Vector<SpanInfo>& orderedSpans)
{
   Int32 remainingSpan(deltaSpan);
   if (deltaSpan > 0)
   {
      const Int8 increaseSpan(static_cast<Int8>(Math::Ceil(static_cast<Float>(deltaSpan) / spans.Size())));

      for (SizeType i(0); (remainingSpan > 0) && (i < orderedSpans.Size()); ++i)
      {
         const Int8 increaseAmount(increaseSpan > remainingSpan ? static_cast<Int8>(remainingSpan) : increaseSpan);
         remainingSpan -= increaseSpan;

         spans[orderedSpans[i].GetIndex()] += increaseAmount;
      }
   }
}


DistributeToAllItemsOGEmptyCellsPolicy::DistributeToAllItemsOGEmptyCellsPolicy()
{
}
