/* ***************************************************************************************
* FILE:          DefaultPositionsCalculator.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultPositionsCalculator is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "DefaultPositionsCalculator.h"

using namespace Candera;


DefaultPositionsCalculator::~DefaultPositionsCalculator()
{
}


FeatStd::Float DefaultPositionsCalculator::CalculateStartingPosition(const ITemplateRetriever& /*templateRetriever*/, const ContentProvider& /*contentProvider*/, const Candera::UInt32 startIndex) const
{
   return Float(startIndex);
}


FeatStd::Int32 DefaultPositionsCalculator::CalculateStartIndex(const ITemplateRetriever& /*templateRetriever*/, const ContentProvider& /*contentProvider*/, const Candera::Float position) const
{
   return Int32(position);
}


DefaultPositionsCalculator::DefaultPositionsCalculator()
{
}
